INSERT IGNORE INTO `hlstats_Actions` (`game`, `code`, `reward_player`, `reward_team`, `team`, `description`, `for_PlayerActions`, `for_PlayerPlayerActions`, `for_TeamActions`, `for_WorldActions`)
(SELECT code, 'medic_extinguish', 1, 0, '', 'Extinguished Teammate (Medic)', '1', '0', '0', '0' FROM hlstats_Games WHERE `realgame` = 'tf');

INSERT IGNORE INTO `hlstats_Actions` (`game`, `code`, `reward_player`, `reward_team`, `team`, `description`, `for_PlayerActions`, `for_PlayerPlayerActions`, `for_TeamActions`, `for_WorldActions`)
(SELECT code, 'engineer_extinguish', 1, 0, '', 'Extinguished Teammate (Engineer)', '1', '0', '0', '0' FROM hlstats_Games WHERE `realgame` = 'tf');

INSERT IGNORE INTO `hlstats_Actions` (`game`, `code`, `reward_player`, `reward_team`, `team`, `description`, `for_PlayerActions`, `for_PlayerPlayerActions`, `for_TeamActions`, `for_WorldActions`)
(SELECT code, 'teleport', 1, 0, '', 'Teleporter used', '1', '', '', '' FROM hlstats_Games where `realgame` = 'tf');

INSERT IGNORE INTO `hlstats_Actions` (`game`, `code`, `reward_player`, `reward_team`, `team`, `description`, `for_PlayerActions`, `for_PlayerPlayerActions`, `for_TeamActions`, `for_WorldActions`)
(SELECT code, 'teleport_self', 0, 0, '', 'Teleporter used (self)', '1', '', '', '' FROM hlstats_Games where `realgame` = 'tf');

INSERT IGNORE INTO `hlstats_Awards` (`awardType`, `game`, `code`, `name`, `verb`) VALUES
('W', 'nts', 'aa13', 'AA13', 'kills with AA13'),
('W', 'nts', 'grenade_projectile', 'Frag Grenade', 'kills with Frag Grenade'),
('W', 'nts', 'jitte', 'Jitte', 'kills with Jitte'),
('W', 'nts', 'jittescoped', 'Jitte (Scoped)', 'kills with Jitte (Scoped)'),
('W', 'nts', 'knife', 'Knife', 'kills with Knife'),
('W', 'nts', 'kyla', 'KYLA', 'kills with KYLA'),
('W', 'nts', 'm41', 'M41', 'kills with M41'),
('W', 'nts', 'm41l', 'M41L', 'kills with M41L'),
('W', 'nts', 'milso', 'MilSO', 'kills with MilSO'),
('W', 'nts', 'mp5', 'MP5', 'kills with MP5'),
('W', 'nts', 'mpn', 'MPN45', 'kills with MPN45'),
('W', 'nts', 'mx', 'MX', 'kills with MX'),
('W', 'nts', 'mx_silenced', 'MX Silenced', 'kills with MX Silenced'),
('W', 'nts', 'pz', 'PZ252', 'kills with PZ252'),
('W', 'nts', 'grenade_detapack', 'DetPac', 'kills with DetPac'),
('W', 'nts', 'smac', 'SMAC', 'kills with SMAC'),
('W', 'nts', 'srm', 'SRM', 'kills with SRM'),
('W', 'nts', 'srm_s', 'SRM-S', 'kills with SRM-S'),
('W', 'nts', 'srs', 'SRS', 'kills with SRS'),
('W', 'nts', 'supa7', 'MURATA SUPA 7', 'kills with MURATA SUPA 7'),
('W', 'nts', 'tachi', 'TACHI', 'kills with TACHI'),
('W', 'nts', 'zr68c', 'ZR68C', 'kills with ZR68C'),
('W', 'nts', 'zr68l', 'ZR68L', 'kills with ZR68L'),
('W', 'nts', 'zr68s', 'ZR68S', 'kills with ZR68S'),
('W', 'nts', 'mostkills', 'Most Kills', 'kills'),
('W', 'nts', 'latency', 'Best Latency', 'ms average connection'),
('W','hl2mp','mostkills','17. Most Kills','kills'),
('W','hl2mp','suicide','18. Most Suicides','suicides');

INSERT IGNORE INTO `hlstats_Awards` (`awardType`, `game`, `code`, `name`, `verb`)
(SELECT 'P', code, 'shield_blocked', 'Razor Breakin', 'razorbacks broken' FROM hlstats_Games WHERE `realgame` = 'tf');

INSERT IGNORE INTO `hlstats_Awards` (`awardType`, `game`, `code`, `name`, `verb`)
(SELECT 'V', code, 'shield_blocked', 'Broken Back', 'razorbacks broken (sniper)' FROM hlstats_Games WHERE `realgame` = 'tf');

INSERT IGNORE INTO `hlstats_Awards` (`awardType`, `game`, `code`, `name`, `verb`)
(SELECT 'P', code, 'jarate', 'Urine'' For A Surprise', 'jarates' FROM hlstats_Games WHERE `realgame` = 'tf');

INSERT IGNORE INTO `hlstats_Awards` (`awardType`, `game`, `code`, `name`, `verb`)
(SELECT 'V', code, 'jarate', 'Yellow Bellied Spies', 'victims jarated' FROM hlstats_Games WHERE `realgame` = 'tf');

UPDATE `hlstats_Events_Frags` SET `pos_x` = NULL WHERE `pos_x` = '';
UPDATE `hlstats_Events_Frags` SET `pos_y` = NULL WHERE `pos_y` = '';
UPDATE `hlstats_Events_Frags` SET `pos_z` = NULL WHERE `pos_z` = '';

ALTER TABLE `hlstats_Events_Frags`
CHANGE `pos_x` `pos_x` MEDIUMINT default NULL,
CHANGE `pos_y` `pos_y` MEDIUMINT default NULL,
CHANGE `pos_z` `pos_z` MEDIUMINT default NULL,
ADD COLUMN  `pos_victim_x` MEDIUMINT default NULL,
ADD COLUMN  `pos_victim_y` MEDIUMINT default NULL,
ADD COLUMN  `pos_victim_z` MEDIUMINT default NULL;


UPDATE `hlstats_Events_PlayerActions` SET `pos_x` = NULL WHERE `pos_x` = '';
UPDATE `hlstats_Events_PlayerActions` SET `pos_y` = NULL WHERE `pos_y` = '';
UPDATE `hlstats_Events_PlayerActions` SET `pos_z` = NULL WHERE `pos_z` = '';

ALTER TABLE `hlstats_Events_PlayerActions`
CHANGE `pos_x` `pos_x` MEDIUMINT default NULL,
CHANGE `pos_y` `pos_y` MEDIUMINT default NULL,
CHANGE `pos_z` `pos_z` MEDIUMINT default NULL;

UPDATE `hlstats_Events_PlayerPlayerActions` SET `pos_x` = NULL WHERE `pos_x` = '';
UPDATE `hlstats_Events_PlayerPlayerActions` SET `pos_y` = NULL WHERE `pos_y` = '';
UPDATE `hlstats_Events_PlayerPlayerActions` SET `pos_z` = NULL WHERE `pos_z` = '';

ALTER TABLE `hlstats_Events_PlayerPlayerActions`
ADD COLUMN `pos_victim_x` MEDIUMINT default NULL,
ADD COLUMN `pos_victim_y` MEDIUMINT default NULL,
ADD COLUMN `pos_victim_z` MEDIUMINT default NULL;

UPDATE `hlstats_Events_Suicides` SET `pos_x` = NULL WHERE `pos_x` = '';
UPDATE `hlstats_Events_Suicides` SET `pos_y` = NULL WHERE `pos_y` = '';
UPDATE `hlstats_Events_Suicides` SET `pos_z` = NULL WHERE `pos_z` = '';

ALTER TABLE `hlstats_Events_Suicides`
CHANGE `pos_x` `pos_x` MEDIUMINT default NULL,
CHANGE `pos_y` `pos_y` MEDIUMINT default NULL,
CHANGE `pos_z` `pos_z` MEDIUMINT default NULL;

UPDATE `hlstats_Events_Teamkills` SET `pos_x` = NULL WHERE `pos_x` = '';
UPDATE `hlstats_Events_Teamkills` SET `pos_y` = NULL WHERE `pos_y` = '';
UPDATE `hlstats_Events_Teamkills` SET `pos_z` = NULL WHERE `pos_z` = '';

ALTER TABLE `hlstats_Events_Teamkills`
CHANGE `pos_x` `pos_x` MEDIUMINT default NULL,
CHANGE `pos_y` `pos_y` MEDIUMINT default NULL,
CHANGE `pos_z` `pos_z` MEDIUMINT default NULL,
ADD COLUMN `pos_victim_x` MEDIUMINT default NULL,
ADD COLUMN `pos_victim_y` MEDIUMINT default NULL,
ADD COLUMN `pos_victim_z` MEDIUMINT default NULL;

INSERT IGNORE INTO `hlstats_Games` (`code`, `name`, `realgame`, `hidden`) VALUES
('nts','NeoTokyo','nts','1');

INSERT IGNORE INTO `hlstats_Games_Defaults` (`code`, `parameter`, `value`) VALUES
('nts', 'Admins', ''),
('nts', 'AutoBanRetry', '0'),
('nts', 'AutoTeamBalance', '0'),
('nts', 'BonusRoundIgnore', '0'),
('nts', 'BonusRoundTime', '0'),
('nts', 'BroadCastEvents', '1'),
('nts', 'BroadCastPlayerActions', '1'),
('nts', 'ConnectAnnounce', '1'),
('nts', 'DefaultDisplayEvents', '1'),
('nts', 'DisplayResultsInBrowser', '1'),
('nts', 'EnablePublicCommands', '1'),
('nts', 'GameEngine', '2'),
('nts', 'GameType', '0'),
('nts', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('nts', 'IgnoreBots', '1'),
('nts', 'MinimumPlayersRank', '0'),
('nts', 'MinPlayers', '4'),
('nts', 'PlayerEvents', '1'),
('nts', 'ShowStats', '1'),
('nts', 'SkillMode', '0'),
('nts', 'SuicidePenalty', '5'),
('nts', 'SwitchAdmins', '0'),
('nts', 'TKPenalty', '25'),
('nts', 'TrackServerLoad', '1'),
('nts', 'UpdateHostname', '1');


INSERT IGNORE INTO `hlstats_Games_Supported` (`code`, `name`) VALUES
('nts','NeoTokyo');

CREATE TABLE IF NOT EXISTS `hlstats_Heatmap_Config` (
  `id` int(255) NOT NULL auto_increment,
  `map` varchar(64) NOT NULL,
  `game` varchar(32) NOT NULL,
  `xoffset` float NOT NULL,
  `yoffset` float NOT NULL,
  `flipx` tinyint(1) NOT NULL default '0',
  `flipy` tinyint(1) NOT NULL default '1',
  `days` tinyint(4) NOT NULL default '30',
  `brush` varchar(5) NOT NULL default 'small',
  `scale` float NOT NULL,
  `font` tinyint(2) NOT NULL default '10',
  `thumbw` float NOT NULL default '0.170312',
  `thumbh` float NOT NULL default '0.170312',
  `cropx1` int(11) NOT NULL default '0',
  `cropy1` int(11) NOT NULL default '0',
  `cropx2` int(11) NOT NULL default '0',
  `cropy2` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `gamemap` (`map`, `game`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Heatmap_Config`
--

INSERT IGNORE INTO `hlstats_Heatmap_Config` (`map`, `game`, `xoffset`, `yoffset`, `flipx`, `flipy`, `days`, `brush`, `scale`, `font`, `thumbw`, `thumbh`, `cropx1`, `cropy1`, `cropx2`, `cropy2`) VALUES
('de_dust2', 'css', 5290, 4259, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('plr_pipeline', 'tf', 8006, 9236, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_hoodoo_final', 'tf', 9564, 5592, 0, 1, 30, 'small', 14, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_dustbowl', 'tf', 5109, 4821, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ctf_2fort', 'tf', 5112, 4079, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_goldrush', 'tf', 10669, 4221, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_egypt_final', 'tf', 9844, 9241, 0, 1, 30, 'small', 16, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_junction_final', 'tf', 4077, 5145, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_fastlane', 'tf', 7692, 5622, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_badwater', 'tf', 4269, 3237, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_steel', 'tf', 4069, 2637, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_badlands', 'tf', 6205, 5059, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_granary', 'tf', 9274, 6088, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_gravelpit', 'tf', 5735, 5645, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_cashworks_b3a', 'tf', 5500, 4635, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_office', 'css', 2357, 1766, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_ambush', 'bg2', 5592, 1159, 0, 1, 30, 'small', 8.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_townguard', 'bg2', 4489, 2670, 0, 1, 30, 'small', 5.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_dust', 'css', 3425, 4022, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_anzio', 'dods', 4031, 3979, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_argentan', 'dods', 4773, 2963, 0, 1, 30, 'small', 6.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_avalanche', 'dods', 3204, 2885, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_colmar', 'dods', 5915, 5373, 0, 1, 30, 'small', 9.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_donner', 'dods', 4013, 1743, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_flash', 'dods', 3895, 2330, 0, 1, 30, 'small', 5.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_jagd', 'dods', 3592, 3082, 0, 1, 30, 'small', 6.6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_kalt', 'dods', 777, 6987, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_palermo', 'dods', 2494, 3797, 0, 1, 30, 'small', 6.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_abdallah', 'insmod', 7508, 2723, 0, 1, 30, 'small', 9.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_almaden', 'insmod', 2881, 3200, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_bagdad', 'insmod', 9166, 4578, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_buhriz', 'insmod', 11943, 8220, 0, 1, 30, 'small', 16, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_haditha', 'insmod', 5582, 2630, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_haditha_night', 'insmod', 5582, 2630, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_hillah', 'insmod', 6755, 3550, 0, 1, 30, 'small', 11.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_karkar', 'insmod', 10355, 1306, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_ramadi', 'insmod', 5069, 1430, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_samawah', 'insmod', 2947, 2112, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_sinjar', 'insmod', 7427, 6887, 0, 1, 30, 'small', 11, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_samawah_day', 'insmod', 2809, 2152, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_badlands', 'tf', 5125, 4119, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_granary', 'tf', 6759, 4013, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_lumberyard', 'tf', 6616, 5421, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_nucleus', 'tf', 2562, 1940, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_ravine', 'tf', 2647, 3547, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_sawmill', 'tf', 4551, 4259, 0, 1, 30, 'small', 8.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_watchtower', 'tf', 3789, 3075, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_well', 'tf', 5331, 3389, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ctf_turbine', 'tf', 4496, 3593, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ctf_well', 'tf', 6437, 5123, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('tc_hydro', 'tf', 6038, 4348, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_castle4', 'tf', 4120, 7826, 0, 1, 30, 'small', 11, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_follower', 'tf', 8871, 6631, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_labor', 'tf', 5788, 3873, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_stag', 'tf', 5099, 4021, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ctf_chaos', 'tf', 3899, 3214, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dom_canalzone', 'tf', 4044, 3664, 0, 1, 30, 'small', 6.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_frontier', 'tf', 6094, 4051, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_halfacre', 'tf', 5098, 5920, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_airport01_greenhouse', 'l4d', 979, 3935, 0, 0, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_airport03_garage', 'l4d', 11413, 6781, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_airport04_terminal', 'l4d', 2659, 6795, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_airport05_runway', 'l4d', 8197, 12894, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_farm01_hilltop', 'l4d', 14734, 5840, 1, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_farm02_traintunnel', 'l4d', 11001, 3377, 1, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_farm03_bridge', 'l4d', 1353, 7488, 1, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_farm04_barn', 'l4d', 3091, 186, 1, 0, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_farm05_cornfield', 'l4d', 4448, 5460, 0, 0, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_hospital01_apartment', 'l4d', 662, 5571, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_hospital02_subway', 'l4d', 1621, 8552, 0, 0, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_hospital03_sewers', 'l4d', 7045, 14101, 0, 0, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_hospital04_interior', 'l4d', 9513, 16235, 0, 0, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_hospital05_rooftop', 'l4d', 4450, 10005, 0, 0, 30, 'small', 3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_smalltown01_caves', 'l4d', 20542, 3156, 1, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_smalltown02_drainage', 'l4d', 12149, 4040, 1, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_smalltown05_houseboat', 'l4d', 6554, 5155, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_jungle_a1c', 'tf', 3024, 5391, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_strider_v1', 'tf', 7109, 4078, 0, 1, 30, 'small', 7.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_warpath_v3', 'tf', 3995, 3298, 0, 1, 30, 'small', 6.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('grubas_nabijacz!_v6', 'tf', 2004, 2478, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_boulder_v5', 'tf', 9562, 12307, 0, 1, 30, 'small', 16, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_broma', 'tf', 5261, 3192, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_busytown', 'tf', 6413, 5961, 0, 1, 30, 'small', 11, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_roswell', 'tf', 2809, 4448, 0, 1, 30, 'small', 6.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_vertigo_beta3', 'tf', 3584, 3108, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_wolf2_b1', 'tf', 2182, 3838, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ctf_convoy_v2', 'tf', 3732, 2694, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_well', 'tf', 10371, 7681, 0, 1, 30, 'small', 15, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_furnace_b2', 'tf', 4667, 4823, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_borax_b2', 'tf', 5252, 593, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_jailbreak_b3', 'tf', 8570, -702, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_desertfortress', 'tf', 3675, 3269, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_train', 'css', 2616, 2619, 0, 1, 30, 'small', 4.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_tides', 'css', 2385, 1589, 0, 1, 30, 'small', 3.7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_prodigy', 'css', 1025, 2198, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_port', 'css', 4189, 4131, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_piranesi', 'css', 3082, 3239, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_nuke', 'css', 3541, 1856, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_inferno', 'css', 3336, 4252, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_chateau', 'css', 2121, 3074, 0, 1, 30, 'small', 4.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_cbble', 'css', 4704, 3587, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_aztec', 'css', 4235, 3430, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_militia', 'css', 2838, 2745, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_italy', 'css', 3071, 2920, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_havana', 'css', 2958, 2678, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_compound', 'css', 1734, 3943, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_assault', 'css', 2467, 8268, 0, 0, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dm_lockdown', 'hl2mp', 7301, 7172, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dm_overwatch', 'hl2mp', 1997, 8416, 0, 0, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dm_powerhouse', 'hl2mp', 2558, 762, 0, 1, 30, 'small', 3.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dm_resistance', 'hl2mp', 2606, 2129, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dm_runoff', 'hl2mp', 5116, 5210, 0, 0, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dm_steamlab', 'hl2mp', 3854, 3471, 0, 1, 30, 'small', 2.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dm_underpass', 'hl2mp', 1611, 364, 0, 1, 30, 'small', 2.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('coop_elpaso', 'fof', 7369, 4167, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('coop_peligro', 'fof', 10378, 4070, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('coop_revenge', 'fof', 1687, 2560, 0, 1, 30, 'small', 3.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('coop_sweetwater', 'fof', 2289, 1565, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_canyonland', 'fof', 6026, 6913, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_desert', 'fof', 5996, 2255, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_desperados', 'fof', 613, -645, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_eliminator', 'fof', 5944, 7040, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_eliminator_lite', 'fof', 3306, 4981, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_elpaso', 'fof', 7031, 4138, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_loothill', 'fof', 6196, 5624, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_monumentvalley', 'fof', 2563, 6738, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_nowhere', 'fof', 4977, 1796, 0, 1, 30, 'small', 5.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_peligro', 'fof', 4913, 4044, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_peligro_lite', 'fof', 3983, 3030, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_presidio', 'fof', 3149, 1539, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_revenge', 'fof', 1685, 2584, 0, 1, 30, 'small', 3.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_sweetwater', 'fof', 2289, 1565, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_tijuana', 'fof', 3692, 3638, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_tramonto', 'fof', 4743, 2026, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_tramonto_lite', 'fof', 3465, 1094, 0, 1, 30, 'small', 3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('as_oilrig', 'cstrike', 588.81, -730.75, 0, 0, 30, 'small', 2.48, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_747', 'cstrike', 64, -608, 0, 1, 30, 'small', 1.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_assault', 'cstrike', 720, 1024, 0, 1, 30, 'small', 1.54, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_backalley', 'cstrike', 148, 1360, 0, 0, 30, 'small', 2.08, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_estate', 'cstrike', 144, -928, 0, 1, 30, 'small', 2.04, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_havana', 'cstrike', 256, 56, 0, 0, 30, 'small', 1.38, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_italy', 'cstrike', 248, 16, 0, 1, 30, 'small', 1.57, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_militia', 'cstrike', 621, -534, 0, 0, 30, 'small', 1.69, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_office', 'cstrike', 64, -260, 0, 1, 30, 'small', 1.47, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_siege', 'cstrike', 564, 1252, 0, 0, 30, 'small', 1.15, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_airstrip', 'cstrike', 1116, -368, 0, 1, 30, 'small', 1.21, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_aztec', 'cstrike', 447.31, -62.94, 0, 1, 30, 'small', 1.12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_cbble', 'cstrike', 832, 576, 0, 1, 30, 'small', 1.07, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_chateau', 'cstrike', 1032, 688.5, 0, 0, 30, 'small', 1.46, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_dust', 'cstrike', 96, 960, 0, 1, 30, 'small', 1.1, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_dust2', 'cstrike', 384, 1120, 0, 1, 30, 'small', 1.26, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_inferno', 'cstrike', 404, 1312, 0, 0, 30, 'small', 1.39, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_nuke', 'cstrike', 244, -936, 0, 0, 30, 'small', 1.14, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_piranesi', 'cstrike', 48, 864, 0, 0, 30, 'small', 1.37, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_prodigy', 'cstrike', 1476, -264, 0, 0, 30, 'small', 1.94, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_storm', 'cstrike', 191, -104, 0, 0, 30, 'small', 1.42, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_survivor', 'cstrike', 832, 880, 0, 0, 30, 'small', 1.38, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_torn', 'cstrike', 112, 664, 0, 0, 30, 'small', 1.24, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_train', 'cstrike', 49.19, 156, 0, 0, 30, 'small', 1.58, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_vertigo', 'cstrike', 1280, -256, 0, 1, 30, 'small', 2.13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_dusk_patrol', 'bg2', 6504, 4690, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_fall', 'bg2', 1198, 2503, 0, 1, 30, 'small', 4.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_foothills', 'bg2', 5440, 5115, 0, 1, 30, 'small', 8.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_freemans_farm', 'bg2', 6648, 5275, 0, 1, 30, 'small', 10.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_maricopa', 'bg2', 6398, 2313, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_pillage', 'bg2', 3746, 6363, 0, 1, 30, 'small', 9.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_pinebarrens', 'bg2', 257, 6121, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_plateau', 'bg2', 3840, 3085, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_road', 'bg2', 5149, 3755, 0, 1, 30, 'small', 8.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_snowlake', 'bg2', 6194, 7018, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_woodland', 'bg2', 4924, 3236, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_harbourtown', 'bg2', 2123, 4443, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_battleground', 'aoc', 4969, 2889, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_darkforest', 'aoc', 5984, 9812, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_firecrag', 'aoc', 3585, 10952, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_helms_deep', 'aoc', 5672, 2522, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_invasion', 'aoc', 3979, 3593, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_monastery', 'aoc', 5549, 3561, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_overlook', 'aoc', 3711, 2781, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_siege', 'aoc', 3186, 4274, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_sorrow', 'aoc', 4128, 6654, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_stoneshill', 'aoc', 7175, 5685, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_theshore', 'aoc', 540, 7698, 0, 0, 30, 'small', 14, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_tombs', 'aoc', 1287, 995, 0, 1, 30, 'small', 2, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_tournament', 'aoc', 1353, 1750, 0, 1, 30, 'small', 2.2, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_valley', 'aoc', 4573, 3442, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_westerlyn', 'aoc', 7166, 6094, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_2fort', 'ff', 5582, 4318, 0, 1, 30, 'small', 8.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_2morforever', 'ff', 3458, 2582, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_aardvark', 'ff', 5725, 3384, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_anticitizen', 'ff', 9919, 5646, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_attrition', 'ff', 3086, 2571, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_bases', 'ff', 5084, 4099, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_cornfield', 'ff', 4987, 3476, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_crossover', 'ff', 5996, 4577, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_cz2', 'ff', 4672, 3836, 0, 1, 30, 'small', 7.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_destroy', 'ff', 4945, 4018, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_dm', 'ff', 1917, 1501, 0, 1, 30, 'small', 3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_dropdown', 'ff', 4529, 3539, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_dustbowl', 'ff', 5457, 4520, 0, 1, 30, 'small', 8.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_epicenter', 'ff', 3781, 3037, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_hunted', 'ff', 6151, 5125, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_impact', 'ff', 4096, 2190, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_monkey', 'ff', 4989, 4082, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_openfire', 'ff', 3173, 2504, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_palermo', 'ff', 6191, 3333, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_pitfall', 'ff', 4485, 3633, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_push', 'ff', 4744, 3849, 0, 1, 30, 'small', 7.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_schtop', 'ff', 4802, 3837, 0, 1, 30, 'small', 7.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_shutdown2', 'ff', 4703, 3825, 0, 1, 30, 'small', 7.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_tiger', 'ff', 2686, 1858, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_vertigo', 'ff', 2010, 1500, 0, 1, 30, 'small', 3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_waterpolo', 'ff', 3209, 2608, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_well', 'ff', 4482, 3423, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_airport01_greenhouse', 'l4d', 979, 3935, 0, 0, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_airport03_garage', 'l4d', 11413, 6781, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_airport04_terminal', 'l4d', 2659, 6795, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_airport05_runway', 'l4d', 8197, 12894, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_farm01_hilltop', 'l4d', 14734, 5840, 1, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_farm02_traintunnel', 'l4d', 11001, 3377, 1, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_farm03_bridge', 'l4d', 1353, 7488, 1, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_farm04_barn', 'l4d', 3091, 186, 1, 0, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_farm05_cornfield', 'l4d', 4448, 5460, 0, 0, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_hospital01_apartment', 'l4d', 662, 5571, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_hospital02_subway', 'l4d', 1621, 8552, 0, 0, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_hospital03_sewers', 'l4d', 7045, 14101, 0, 0, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_hospital04_interior', 'l4d', 9513, 16235, 0, 0, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_hospital05_rooftop', 'l4d', 4450, 10005, 0, 0, 30, 'small', 3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_smalltown01_caves', 'l4d', 20542, 3156, 1, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_smalltown02_drainage', 'l4d', 12149, 4040, 1, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_dawn_ctg', 'nts', 3447, 5426, 0, 1, 30, 'small', 5.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_engage_ctg', 'nts', 4112, 4024, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_ghost_ctg', 'nts', 4951, 6131, 0, 1, 30, 'small', 7.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_isolation_ctg', 'nts', 5357, 3549, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_rise_ctg', 'nts', 2205, 2044, 0, 1, 30, 'small', 3.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_shrine_ctg', 'nts', 4976, 6388, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_skyline_ctg', 'nts', 4516, 2141, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_subsurface_ctg', 'nts', 3319, 1552, 0, 1, 30, 'small', 6.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_tarmac_ctg', 'nts', 2359, 3388, 0, 1, 30, 'small', 5.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_transit_ctg', 'nts', 2749, 1879, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0);

DROP TABLE `hlstats_Livestats`;

CREATE TABLE IF NOT EXISTS `hlstats_Livestats` (
  `player_id` int(10) NOT NULL default '0',
  `server_id` int(4) NOT NULL default '0',
  `cli_address` varchar(32) NOT NULL default '',
  `cli_city` varchar(64) NOT NULL default '',
  `cli_country` varchar(64) NOT NULL default '',
  `cli_flag` varchar(16) NOT NULL default '',
  `cli_state` varchar(64) NOT NULL default '',
  `cli_lat` FLOAT(7,4) NULL,
  `cli_lng` FLOAT(7,4) NULL,
  `steam_id` varchar(64) NOT NULL default '',
  `name` varchar(64) NOT NULL,
  `team` varchar(64) NOT NULL default '',
  `kills` int(6) NOT NULL default '0',
  `deaths` int(6) NOT NULL default '0',
  `suicides` int(6) NOT NULL default '0',
  `headshots` int(6) NOT NULL default '0',
  `shots` int(11) NOT NULL default '0',
  `hits` int(11) NOT NULL default '0',
  `is_dead` tinyint(1) NOT NULL default '0',
  `has_bomb` int(1) NOT NULL default '0',
  `ping` int(6) NOT NULL default '0',
  `connected` int(10) NOT NULL default '0',
  `skill_change` int(10) NOT NULL default '0',
  `skill` int(10) NOT NULL default '0',
  PRIMARY KEY  (`player_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

CREATE TABLE `hlstats_Maps_Counts` (
  `rowId` int(11) NOT NULL auto_increment,
  `game` varchar(32) character set utf8 NOT NULL,
  `map` varchar(64) character set utf8 NOT NULL,
  `kills` int(11) NOT NULL,
  `headshots` int(11) NOT NULL,
  PRIMARY KEY  (`game`,`map`),
  INDEX ( `rowId` )
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `hlstats_Maps_Counts` (`game`, `map`, `kills`, `headshots`)
SELECT `hlstats_Servers`.`game`, `hlstats_Events_Frags`.`map`, COUNT(`hlstats_Events_Frags`.`killerId`), SUM(`hlstats_Events_Frags`.`headshot`) FROM `hlstats_Events_Frags` INNER JOIN `hlstats_Servers` ON `hlstats_Events_Frags`.`serverId` = `hlstats_Servers`.`serverId` WHERE `hlstats_Events_Frags`.`map` <> '' GROUP BY `hlstats_Servers`.`game`, `hlstats_Events_Frags`.`map`;

UPDATE `hlstats_Options` SET `opttype` = 2 WHERE `keyname` = 'MinActivity';

ALTER TABLE `hlstats_Players`
ADD `activity` int(11) NOT NULL default '100',
CHANGE `lat` `lat` FLOAT(7,4) NULL,
CHANGE `lng` `lng` FLOAT(7,4) NULL;

INSERT IGNORE INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`) VALUES
('nts', 'recruit', 0, 49, 'Recruit'),
('nts', 'private', 50, 99, 'Private'),
('nts', 'private-first-class', 100, 199, 'Private First Class'),
('nts', 'lance-corporal', 200, 299, 'Lance Corporal'),
('nts', 'corporal', 300, 399, 'Corporal'),
('nts', 'sergeant', 400, 499, 'Sergeant'),
('nts', 'staff-sergeant', 500, 599, 'Staff Sergeant'),
('nts', 'gunnery-sergeant', 600, 699, 'Gunnery Sergeant'),
('nts', 'master-sergeant', 700, 799, 'Master Sergeant'),
('nts', 'first-sergeant', 800, 899, 'First Sergeant'),
('nts', 'master-chief', 900, 999, 'Master Chief'),
('nts', 'sergeant-major', 1000, 1199, 'Sergeant Major'),
('nts', 'ensign', 1200, 1399, 'Ensign'),
('nts', 'third-lieutenant', 1400, 1599, 'Third Lieutenant'),
('nts', 'second-lieutenant', 1600, 1799, 'Second Lieutenant'),
('nts', 'first-lieutenant', 1800, 1999, 'First Lieutenant'),
('nts', 'captain', 2000, 2249, 'Captain'),
('nts', 'group-captain', 2250, 2499, 'Group Captain'),
('nts', 'senior-captain', 2500, 2749, 'Senior Captain'),
('nts', 'lieutenant-major', 2750, 2999, 'Lieutenant Major'),
('nts', 'major', 3000, 3499, 'Major'),
('nts', 'group-major', 3500, 3999, 'Group Major'),
('nts', 'lieutenant-commander', 4000, 4499, 'Lieutenant Commander'),
('nts', 'commander', 4500, 4999, 'Commander'),
('nts', 'group-commander', 5000, 5749, 'Group Commander'),
('nts', 'lieutenant-colonel', 5750, 6499, 'Lieutenant Colonel'),
('nts', 'colonel', 6500, 7249, 'Colonel'),
('nts', 'brigadier', 7250, 7999, 'Brigadier'),
('nts', 'brigadier-general', 8000, 8999, 'Brigadier General'),
('nts', 'major-general', 9000, 9999, 'Major General'),
('nts', 'lieutenant-general', 10000, 12499, 'Lieutenant General'),
('nts', 'general', 12500, 14999, 'General'),
('nts', 'commander-general', 15000, 17499, 'Commander General'),
('nts', 'field-vice-marshal', 17500, 19999, 'Field Vice Marshal'),
('nts', 'field-marshal', 20000, 22499, 'Field Marshal'),
('nts', 'vice-commander-of-the-army', 22500, 24999, 'Vice Commander of the Army'),
('nts', 'commander-of-the-army', 25000, 27499, 'Commander of the Army'),
('nts', 'high-commander', 27500, 29999, 'High Commander'),
('nts', 'supreme-commander', 30000, 34999, 'Supreme Commander'),
('nts', 'terminator', 35000, 9999999, 'Terminator');

INSERT IGNORE INTO `hlstats_Ribbons` (`awardCode`, `awardCount`, `special`, `game`, `image`, `ribbonName`) VALUES
('ak47',1,0,'cstrike','1_ak47.png','Award of AK47'),
('awp',1,0,'cstrike','1_awp.png','Award of AWP Sniper'),
('deagle',1,0,'cstrike','1_deagle.png','Award of Desert Eagle'),
('elite',1,0,'cstrike','1_elite.png','Award of Dual Beretta Elites'),
('famas',1,0,'cstrike','1_famas.png','Award of Fusil Automatique'),
('galil',1,0,'cstrike','1_galil.png','Award of Galil'),
('glock18',1,0,'cstrike','1_glock.png','Award of Glock'),
('grenade',1,0,'cstrike','1_hegrenade.png','Award of Grenade'),
('knife',1,0,'cstrike','1_knife.png','Award of Combat Knife'),
('latency',1,0,'cstrike','1_latency.png','Award of Lowpinger'),
('m3',1,0,'cstrike','1_m3.png','Award of M3 Super'),
('m4a1',1,0,'cstrike','1_m4a1.png','Award of Colt M4A1'),
('p90',1,0,'cstrike','1_p90.png','Award of P90'),
('scout',1,0,'cstrike','1_scout.png','Award of Scout Elite'),
('usp',1,0,'cstrike','1_usp.png','Award of USP'),
('Defused_The_Bomb',1,0,'cstrike','1_defused_the_bomb.png','Award of Bomb Defuser'),
('Planted_The_Bomb',1,0,'cstrike','1_planted_the_bomb.png','Award of Bomb Planter'),
('Rescued_A_Hostage',1,0,'cstrike','1_rescued_a_hostage.png','Award of Hostage Rescuer'),
('Assassinated_The_VIP',1,0,'cstrike','1_killed_a_hostage.png','Award of Top Assassin'),
('ak47',5,0,'cstrike','2_ak47.png','Bronze AK47'),
('awp',5,0,'cstrike','2_awp.png','Bronze AWP Sniper'),
('deagle',5,0,'cstrike','2_deagle.png','Bronze Desert Eagle'),
('elite',5,0,'cstrike','2_elite.png','Bronze Dual Beretta Elites'),
('famas',5,0,'cstrike','2_famas.png','Bronze Fusil Automatique'),
('galil',5,0,'cstrike','2_galil.png','Bronze Galil'),
('glock18',5,0,'cstrike','2_glock.png','Bronze Glock'),
('grenade',5,0,'cstrike','2_hegrenade.png','Bronze Grenade'),
('knife',5,0,'cstrike','2_knife.png','Bronze Combat Knife'),
('latency',5,0,'cstrike','2_latency.png','Bronze Lowpinger'),
('m3',5,0,'cstrike','2_m3.png','Bronze Award M3 Super'),
('m4a1',5,0,'cstrike','2_m4a1.png','Bronze AColt M4A1'),
('p90',5,0,'cstrike','2_p90.png','Bronze P90'),
('scout',5,0,'cstrike','2_scout.png','Bronze Scout Elite'),
('usp',5,0,'cstrike','2_usp.png','Bronze USP'),
('Defused_The_Bomb',5,0,'cstrike','2_defused_the_bomb.png','Bronze Bomb Defuser'),
('Planted_The_Bomb',5,0,'cstrike','2_planted_the_bomb.png','Bronze Bomb Planter'),
('Rescued_A_Hostage',5,0,'cstrike','2_rescued_a_hostage.png','Bronze Hostage Rescuer'),
('Assassinated_The_VIP',5,0,'cstrike','2_killed_a_hostage.png','Bronze Top Assassin'),
('ak47',12,0,'cstrike','3_ak47.png','Silver AK47'),
('awp',12,0,'cstrike','3_awp.png','Silver Sniper'),
('deagle',12,0,'cstrike','3_deagle.png','Silver Desert Eagle'),
('elite',12,0,'cstrike','3_elite.png','Silver Dual Beretta Elites'),
('famas',12,0,'cstrike','3_famas.png','Silver Fusil Automatique'),
('galil',12,0,'cstrike','3_galil.png','Silver Galil'),
('glock18',12,0,'cstrike','3_glock.png','Silver Glock'),
('grenade',12,0,'cstrike','3_hegrenade.png','Silver Grenade'),
('knife',12,0,'cstrike','3_knife.png','Silver Combat Knife'),
('latency',12,0,'cstrike','3_latency.png','Silver Lowpinger'),
('m3',12,0,'cstrike','3_m3.png','Silver M3 Super'),
('m4a1',12,0,'cstrike','3_m4a1.png','Silver Colt M4A1'),
('p90',12,0,'cstrike','3_p90.png','Silver P90'),
('scout',12,0,'cstrike','3_scout.png','Silver Scout Elite'),
('usp',12,0,'cstrike','3_usp.png','Silver USP'),
('Defused_The_Bomb',12,0,'cstrike','3_defused_the_bomb.png','Silver Bomb Defuser'),
('Planted_The_Bomb',12,0,'cstrike','3_planted_the_bomb.png','Silver Bomb Planter'),
('Rescued_A_Hostage',12,0,'cstrike','3_rescued_a_hostage.png','Silver Hostage Rescuer'),
('Assassinated_The_VIP',12,0,'cstrike','3_killed_a_hostage.png','Silver Top Assassin'),
('ak47',20,0,'cstrike','4_ak47.png','Gold AK47'),
('awp',20,0,'cstrike','4_awp.png','Gold AWP Sniper'),
('deagle',20,0,'cstrike','4_deagle.png','Gold Desert Eagle'),
('elite',20,0,'cstrike','4_elite.png','Gold Dual Beretta Elites'),
('famas',20,0,'cstrike','4_famas.png','Gold Fusil Automatique'),
('galil',20,0,'cstrike','4_galil.png','GoldGalil'),
('glock18',20,0,'cstrike','4_glock.png','Gold Glock'),
('grenade',20,0,'cstrike','4_hegrenade.png','Gold Grenade'),
('knife',20,0,'cstrike','4_knife.png','Gold Combat Knife'),
('latency',20,0,'cstrike','4_latency.png','Gold Lowpinger'),
('m3',20,0,'cstrike','4_m3.png','Gold M3 Super'),
('m4a1',20,0,'cstrike','4_m4a1.png','Gold Colt M4A1'),
('p90',20,0,'cstrike','4_p90.png','Gold P90'),
('scout',20,0,'cstrike','4_scout.png','Gold Scout Elite'),
('usp',20,0,'cstrike','4_usp.png','Gold USP'),
('Defused_The_Bomb',20,0,'cstrike','4_defused_the_bomb.png','Gold Bomb Defuser'),
('Planted_The_Bomb',20,0,'cstrike','4_planted_the_bomb.png','Gold Bomb Planter'),
('Rescued_A_Hostage',20,0,'cstrike','4_rescued_a_hostage.png','Gold Hostage Rescuer'),
('Assassinated_The_VIP',20,0,'cstrike','4_killed_a_hostage.png','Gold Top Assassin'),
('ak47',30,0,'cstrike','5_ak47.png','Platinum AK47'),
('awp',30,0,'cstrike','5_awp.png','Platinum AWP Sniper'),
('deagle',30,0,'cstrike','5_deagle.png','Platinum Desert Eagle'),
('elite',30,0,'cstrike','5_elite.png','Platinum Dual Beretta Elites'),
('famas',30,0,'cstrike','5_famas.png','Platinum Fusil Automatique'),
('galil',30,0,'cstrike','5_galil.png','Platinum Galil'),
('glock18',30,0,'cstrike','5_glock.png','Platinum Glock'),
('grenade',30,0,'cstrike','5_hegrenade.png','Platinum Grenade'),
('knife',30,0,'cstrike','5_knife.png','PlatinumCombat Knife'),
('latency',30,0,'cstrike','5_latency.png','PlatinumLowpinger'),
('m3',30,0,'cstrike','5_m3.png','Platinum M3 Super'),
('m4a1',30,0,'cstrike','5_m4a1.png','Platinum Colt M4A1'),
('p90',30,0,'cstrike','5_p90.png','Platinum P90'),
('scout',30,0,'cstrike','5_scout.png','Platinum Scout Elite'),
('usp',30,0,'cstrike','5_usp.png','Platinum USP'),
('Defused_The_Bomb',30,0,'cstrike','5_defused_the_bomb.png','Platinum Bomb Defuser'),
('Planted_The_Bomb',30,0,'cstrike','5_planted_the_bomb.png','Platinum Bomb Planter'),
('Rescued_A_Hostage',30,0,'cstrike','5_rescued_a_hostage.png','Platinum Hostage Rescuer'),
('Assassinated_The_VIP',30,0,'cstrike','5_killed_a_hostage.png','Platinum Top Assassin'),
('ak47',50,0,'cstrike','6_ak47.png','Supreme AK47'),
('awp',50,0,'cstrike','6_awp.png','Supreme AWP Sniper'),
('deagle',50,0,'cstrike','6_deagle.png','Supremef Desert Eagle'),
('elite',50,0,'cstrike','6_elite.png','Supreme Dual Beretta Elites'),
('famas',50,0,'cstrike','6_famas.png','Supreme Fusil Automatique'),
('galil',50,0,'cstrike','6_galil.png','Supreme Galil'),
('glock18',50,0,'cstrike','6_glock.png','Supreme Glock'),
('grenade',50,0,'cstrike','6_hegrenade.png','Supreme Grenade'),
('knife',50,0,'cstrike','6_knife.png','Supreme Combat Knife'),
('latency',50,0,'cstrike','6_latency.png','Supreme Lowpinger'),
('m3',50,0,'cstrike','6_m3.png','Supreme M3 Super'),
('m4a1',50,0,'cstrike','6_m4a1.png','Supreme Colt M4A1'),
('p90',50,0,'cstrike','6_p90.png','Supremef P90'),
('scout',50,0,'cstrike','6_scout.png','Supreme Scout Elite'),
('usp',50,0,'cstrike','6_usp.png','Supreme USP'),
('Defused_The_Bomb',50,0,'cstrike','6_defused_the_bomb.png','Supreme Bomb Defuser'),
('Planted_The_Bomb',50,0,'cstrike','6_planted_the_bomb.png','Supreme Bomb Planter'),
('Rescued_A_Hostage',50,0,'cstrike','6_rescued_a_hostage.png','Supreme Hostage Rescuer'),
('Assassinated_The_VIP',50,0,'cstrike','6_killed_a_hostage.png','Supreme Top Assassin'),
('*total connection hours*',25,2,'css','1_connect.png','Connection Time 25 Hours'),
('*total connection hours*',50,2,'css','2_connect.png','Connection Time 50 Hours'),
('*total connection hours*',75,2,'css','3_connect.png','Connection Time 75 Hours'),
('*total connection hours*',100,2,'css','4_connect.png','Connection Time 100 Hours'),
('*total connection hours*',125,2,'css','5_connect.png','Connection Time 125 Hours'),
('*total connection hours*',150,2,'css','6_connect.png','Connection Time 150 Hours'),
('latency',3,0,'hl2mp','1_latency.png','Award of Lowpinger'),
('mostkills',3,0,'hl2mp','1_mostkills.png','Award of Most Kills'),
('suicide',3,0,'hl2mp','1_suicide.png','Award of Most Suicides'),
('latency',7,0,'hl2mp','2_latency.png','Bronze Lowpinger'),
('mostkills',7,0,'hl2mp','2_mostkills.png','Most Kills - Bronze'),
('suicide',7,0,'hl2mp','2_suicide.png','Most Suicides - Bronze'),
('latency',12,0,'hl2mp','3_latency.png','Silver Lowpinger'),
('mostkills',12,0,'hl2mp','3_mostkills.png','Most Kills - Silver'),
('suicide',12,0,'hl2mp','3_suicide.png','Most Suicides - Silver'),
('latency',17,0,'hl2mp','x_latency.png','Supreme Lowpinger'),
('mostkills',17,0,'hl2mp','x_mostkills.png','Most Kills - Supreme'),
('suicide',17,0,'hl2mp','x_suicide.png','Most Suicides - Supreme'),
('galil',1,0,'css','1_galil.png','Award of Galil'),
('galil',5,0,'css','2_galil.png','Bronze Galil'),
('galil',12,0,'css','3_galil.png','Silver Galil'),
('galil',20,0,'css','4_galil.png','Gold Galil'),
('galil',30,0,'css','5_galil.png','Platinum Galil'),
('galil',50,0,'css','6_galil.png','Supreme Galil');

DELETE FROM `hlstats_Ribbons` WHERE `ribbonName` = 'Army Service' AND `game` = 'css' AND `image` = 'ribbon_of_army_service.gif';

INSERT IGNORE INTO `hlstats_Roles` (`game`, `code`, `name`, `hidden`) VALUES
('aoc', 'Longbowman', 'Longbowman', '0'),
('aoc', 'Crossbowman', 'Crossbowman', '0'),
('aoc', 'Javelineer', 'Javelineer', '0'),
('aoc', 'Man at Arms', 'Man at Arms', '0'),
('aoc', 'Sergeant', 'Sergeant', '0'),
('aoc', 'Guardsman', 'Guardsman', '0'),
('aoc', 'Crusader', 'Crusader', '0'),
('aoc', 'Knight', 'Knight', '0'),
('aoc', 'Heavy Knight', 'Heavy Knight', '0');

ALTER TABLE `hlstats_Servers`
ADD `last_event` int(10) unsigned NOT NULL default '0',
CHANGE `lat` `lat` FLOAT(7,4) NULL,
CHANGE `lng` `lng` FLOAT(7,4) NULL;

DELETE FROM `hlstats_Servers_Config` WHERE `parameter` = 'AddressPort';

ALTER TABLE `hlstats_Servers_Teamspeak` RENAME TO `hlstats_Servers_VoiceComm`;

ALTER TABLE `hlstats_Servers_VoiceComm`
CHANGE `tsId` `serverId` int(11) unsigned NOT NULL auto_increment,
CHANGE `tsName` `name` varchar(128) NOT NULL,
CHANGE `tsAddr` `addr` varchar(128) NOT NULL,
CHANGE `tsPassword` `password` varchar(128) default NULL,
CHANGE `tsDesc` `descr` varchar(255) default NULL,
CHANGE `tsQueryPort` `queryPort` int(11) unsigned NOT NULL default '51234',
CHANGE `tsUDPPort` `UDPPort` int(11) unsigned NOT NULL default '8767',
ADD COLUMN `serverType` tinyint(4) NOT NULL default '0';

ALTER TABLE `hlstats_server_load` ADD KEY `timestamp` (`timestamp`);

INSERT IGNORE INTO `hlstats_Teams` (`game`, `code`, `name`, `hidden`, `playerlist_bgcolor`, `playerlist_color`, `playerlist_index`) VALUES
('nts','Jinrai','Jinrai','0','#9AFF9A','#447044',1),
('nts','NSF','NSF','0','#7EA5CC','#4F677F',2);

ALTER TABLE `hlstats_Trend` ADD KEY `timestamp` (`timestamp`);

INSERT IGNORE INTO `hlstats_Weapons` (`game`, `code`, `name`, `modifier`) VALUES
('nts', 'aa13', 'AA13', 1.00),
('nts', 'grenade_projectile', 'Frag Grenade', 1.00),
('nts', 'jitte', 'Jitte', 1.00),
('nts', 'jittescoped', 'Jitte (Scoped)', 1.00),
('nts', 'knife', 'Knife', 1.50),
('nts', 'kyla', 'KYLA', 1.00),
('nts', 'm41', 'M41', 1.00),
('nts', 'm41l', 'M41L', 1.00),
('nts', 'milso', 'MilSO', 1.00),
('nts', 'mp5', 'MP5', 1.00),
('nts', 'mpn', 'MPN45', 1.00),
('nts', 'mx', 'MX', 1.00),
('nts', 'mx_silenced', 'MX Silenced', 1.00),
('nts', 'pz', 'PZ252', 1.00),
('nts', 'grenade_detapack', 'DetPac', 1.00),
('nts', 'smac', 'SMAC', 1.00),
('nts', 'srm', 'SRM', 1.00),
('nts', 'srm_s', 'SRM-S', 1.00),
('nts', 'srs', 'SRS', 1.00),
('nts', 'supa7', 'MURATA SUPA 7', 1.00),
('nts', 'tachi', 'TACHI', 1.00),
('nts', 'zr68c', 'ZR68C', 1.00),
('nts', 'zr68l', 'ZR68L', 1.00),
('nts', 'zr68s', 'ZR68S', 1.00);

INSERT IGNORE INTO `hlstats_Weapons` (`game`, `code`, `name`, `modifier`)
(SELECT `code`, 'deflect_arrow', 'Deflected Arrow', 2 FROM hlstats_Games WHERE `realgame` = 'tf');


UPDATE `hlstats_Options` SET `value` = '1.6.0' WHERE `keyname` = 'version';
